# Day 26: Project 3 - Chat Application

## Tasks/Activities:

### Activity 1: Setting Up the Project
- **Task 1:** Initialize a new project directory and set up the basic HTML structure for the chat application.
- **Task 2:** Add a basic CSS file to style the chat application, including a chat window and input area.

### Activity 2: Setting Up WebSocket Server
- **Task 3:** Set up a simple WebSocket server using Node.js and the `ws` library. Write a script to create the server and handle connections.
- **Task 4:** Test the WebSocket server by logging messages when clients connect and disconnect.

### Activity 3: Establishing WebSocket Connection
- **Task 5:** Add a script to the HTML file to establish a WebSocket connection to the server.
- **Task 6:** Write functions to handle sending and receiving messages through the WebSocket connection. Log received messages to the console.

### Activity 4: Building the Chat Interface
- **Task 7:** Modify the HTML structure to include a chat window and an input area for typing messages. Style the chat window and input area using CSS.
- **Task 8:** Write a function to display received messages in the chat window. Add event listeners to send messages when the user presses Enter or clicks a send button.

### Activity 5: Enhancing the Chat Application
- **Task 9:** Add user authentication to the chat application. Allow users to enter a username before joining the chat. Display usernames alongside their messages in the chat window.
- **Task 10:** Add CSS styles to differentiate messages sent by different users. Add CSS animations or transitions to make the chat application more interactive and visually appealing.

## Feature Request:
1. **WebSocket Server Script:** Write a script to set up a WebSocket server using Node.js and the `ws` library, handling connections and logging messages.
2. **WebSocket Connection Script:** Create a script to establish a WebSocket connection from the client side and handle sending and receiving messages.
3. **Chat Interface Script:** Write a script to build the chat interface, displaying received messages and sending messages from the input area.
4. **User Authentication Script:** Create a script to add user authentication, allowing users to enter usernames and display usernames alongside their messages.
5. **UI Enhancement Script:** Write a script to enhance the chat application's UI with CSS styles and animations, differentiating messages from different users.

## Achievement:
By the end of these activities, students will:
- Set up a basic project structure with HTML and CSS.
- Create a WebSocket server using Node.js and the `ws` library.
- Establish a WebSocket connection from the client side to send and receive messages.
- Build a chat interface to display and send messages.
- Add user authentication and display usernames in the chat.
- Enhance the user interface with CSS styles and animations to make the chat application more interactive and visually appealing.
